import UIKit
import PlaygroundSupport

let contactView = ContactView(frame: CGRect(x: 0.0, y: 0.0, width: 375.0, height: 667.0))
PlaygroundPage.current.liveView = contactView

DispatchQueue.main.asyncAfter(deadline: .now() + 2) {
    UIView.animate(withDuration: 3, animations: {
        contactView.inputFieldHeightConstraint?.constant = 40
        contactView.layoutIfNeeded()
    })
}


final class ContactView: UIView {
    
    let logoImageView = UIImageView(image: UIImage(named: "netguru_logo"))
    let descriptionLabel = UILabel()
    let inputField = UITextField()
    let sendButton = UIButton()
    var inputFieldHeightConstraint: NSLayoutConstraint?
    
    override init(frame: CGRect) {
        super.init(frame: frame)
        attachViews()
        decorate()
        setupConstraints()
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    private func attachViews() {
        addSubview(logoImageView)
        addSubview(descriptionLabel)
        addSubview(inputField)
        addSubview(sendButton)
    }
    
    private func decorate() {
        backgroundColor = .white
        
        logoImageView.contentMode = .scaleAspectFit
        
        descriptionLabel.text = "Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat."
        descriptionLabel.numberOfLines = 0
        
        inputField.borderStyle = .line
        
        sendButton.setTitle("Send", for: .normal)
        sendButton.backgroundColor = .gray
    }
    
    private func setupConstraints() {
        logoImageView.addConstraints([
            equal(\.heightAnchor, to: 50),
            equal(\.widthAnchor, to: 250),
            equal(self, \.centerXAnchor),
            equal(self, \.topAnchor, constant: 50)
        ])
        
        descriptionLabel.addConstraints([
            equal(logoImageView, \.topAnchor, \.bottomAnchor, constant: 20),
            equal(self, \.leadingAnchor, constant: 20),
            equal(self, \.trailingAnchor, constant: -20)
        ])
        
        inputFieldHeightConstraint = inputField.addConstraints([
            equal(\.heightAnchor, to: 180)
        ]).first
        
        inputField.addConstraints([
            equal(\.heightAnchor, to: 180),
            equal(descriptionLabel, \.topAnchor, \.bottomAnchor, constant: 20),
            equal(self, \.leadingAnchor, constant: 20),
            equal(self, \.trailingAnchor, constant: -20)
        ])
        
        sendButton.addConstraints([
            equal(\.heightAnchor, to: 30),
            equal(\.widthAnchor, to: 60),
            equal(inputField, \.trailingAnchor),
            equal(inputField, \.topAnchor, \.bottomAnchor, constant: 20)
        ])
    }
}
